% Plot coupling leakage
clear(); close all;

wavelength = 1; % normalized
d = wavelength / 2;
array_number_change = 81;
designs_number = 11;
n_repeat = 1;

coupling_leakage = zeros(array_number_change, designs_number);
antenna_amount = zeros(array_number_change,1);
for ppp = 1:n_repeat
for ii = 1:array_number_change  
       antenna_number = 19+ii*1;
       antenna_amount (ii,1) = antenna_number;
       design_ana11 = ana11_1d(antenna_number, d);
       design_ana12 = ana11_1d(antenna_number, d);     
       design_nested = nested_1d(antenna_number, d);
       design_supernested_2 = super_nested_1d(antenna_number, 2,d,'Super Nested Q = 2');
       design_supernested_3 = super_nested_1d(antenna_number, 3,d,'Super Nested Q = 3');
       design_MISC = MISC_1d(antenna_number, d);      
       design_ATLI_1BL = ATLI_1BL_1d(antenna_number, d);       
       design_ATLI_2BL = ATLI_2BL_1d(antenna_number, d);    
       design_TSENA = tsena_1d(antenna_number, d);          
       design_ATLI_2BL = ATLI_2BL_1d(antenna_number, d); 
       design_UF_3BL = UF_3BLC1(antenna_number, d);      
       design_UF_4BL = UF_3BLC1(antenna_number, d);       
       
    designs = { ...
    design_MISC,...
    design_UF_3BL,...
    design_UF_4BL,...
    design_nested,...
    design_supernested_2,...
    design_supernested_3,...
    design_ana11,...
    design_ana12,...
    design_ATLI_1BL,...
    design_ATLI_2BL,...
    design_TSENA,...
};

designs_number = length(designs);  
    
        for dn = 1:designs_number
            design = designs{dn};                      
            CL = signal_return_CL(design);     
            coupling_leakage(ii,dn) = coupling_leakage(ii,dn) + CL;
        end
 

end
end
coupling_leakage = coupling_leakage/n_repeat;

markers = {'+', 'o', 'd', '*','s','^','h','p','x','>', '+', 'o', 'd', '*','s','^','h','p','x','>','+', 'o', 'd', '*','s','^','h','p','x','>'};
colors  = {'k','b','r','g','m','c','k','b','r','g','m','c','k','b','r','g','m','c','k','b','r','g','m','c'};
lines = {'-',':','-.','--','-',':','-.','--','-',':','-.','--','-',':','-.','--'};

res_legends1 = {};

figure (1);
for aa = 1:designs_number
  
    Coupling_leakage = coupling_leakage(:,aa);
    
    plot(antenna_amount,Coupling_leakage,[lines{aa} markers{aa} colors{aa}]);
    hold on
 
    
    grid on;
    res_legends1 = [res_legends1 [designs{aa}.name]]; 
    %title([antenna_number, ' Sensors Weight Function']);
end
xlabel('Sensor Number');
ylabel('Coupling Leakage');
legend(res_legends1{:});
